sampler texsampler : register(s0);

// Blurs using a 7x7 filter kernel
float4 main(float2 texcoords : TEXCOORD0) : COLOR0
{
   // distort
      float k = -0.35;
    // cubic distortion value
    float kcube = 0.2;
    
    float r2 = (texcoords.x-0.5) * (texcoords.x-0.5) + (texcoords.y-0.5) * (texcoords.y-0.5);       
    float f = 0;
    
    //only compute the cubic distortion if necessary
    if( kcube == 0.0){
            f = 1 + r2 * k;
    }else{
            f = 1 + r2 * (k + kcube * sqrt(r2));
    };
    
    // get the right pixel for the current position
    texcoords.x = f*(texcoords.x-0.5)+0.5;
    texcoords.y = f*(texcoords.y-0.5)+0.5;
  //
  float4 clr = (
    tex2D(texsampler, texcoords + float2(-3.0f / 512.0f,     -3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-2.0f / 512.0f,     -3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-1.0f / 512.0f,     -3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(0,                   -3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(1.0f / 512.0f,      -3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(2.0f / 512.0f,      -3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(3.0f / 512.0f,      -3.0f / 384.0f)) +
 
    tex2D(texsampler, texcoords + float2(-3.0f / 512.0f,     -2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-2.0f / 512.0f,     -2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-1.0f / 512.0f,     -2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(0,                   -2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(1.0f / 512.0f,      -2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(2.0f / 512.0f,      -2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(3.0f / 512.0f,      -2.0f / 384.0f)) +
 
    tex2D(texsampler, texcoords + float2(-3.0f / 512.0f,     -1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-2.0f / 512.0f,     -1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-1.0f / 512.0f,     -1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(0,                   -1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(1.0f / 512.0f,      -1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(2.0f / 512.0f,      -1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(3.0f / 512.0f,      -1.0f / 384.0f)) +
 
    tex2D(texsampler, texcoords + float2(-3.0f / 512.0f,     0)) +
    tex2D(texsampler, texcoords + float2(-2.0f / 512.0f,     0)) +
    tex2D(texsampler, texcoords + float2(-1.0f / 512.0f,     0)) +
    tex2D(texsampler, texcoords + float2(0,                   0)) +
    tex2D(texsampler, texcoords + float2(1.0f / 512.0f,      0)) +
    tex2D(texsampler, texcoords + float2(2.0f / 512.0f,      0)) +
    tex2D(texsampler, texcoords + float2(3.0f / 512.0f,      0)) +
 
    tex2D(texsampler, texcoords + float2(-3.0f / 512.0f,     1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-2.0f / 512.0f,     1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-1.0f / 512.0f,     1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(0,                   1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(1.0f / 512.0f,      1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(2.0f / 512.0f,      1.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(3.0f / 512.0f,      1.0f / 384.0f)) +
 
    tex2D(texsampler, texcoords + float2(-3.0f / 512.0f,     2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-2.0f / 512.0f,     2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-1.0f / 512.0f,     2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(0,                   2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(1.0f / 512.0f,      2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(2.0f / 512.0f,      2.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(3.0f / 512.0f,      2.0f / 384.0f)) +
 
    tex2D(texsampler, texcoords + float2(-3.0f / 512.0f,     3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-2.0f / 512.0f,     3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(-1.0f / 512.0f,     3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(0,                   3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(1.0f / 512.0f,      3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(2.0f / 512.0f,      3.0f / 384.0f)) +
    tex2D(texsampler, texcoords + float2(3.0f / 512.0f,      3.0f / 384.0f))
  ) / 49;

  float a = 0.4;
  float len = length(texcoords - 0.5);
  if(len < 0.25)
    a *= len * 4;
  return float4(clr.r, clr.g, clr.b, a);
}